'use client';

import * as React from 'react';

type Props = {
  inCart?: boolean;
};

import {constants} from '@/constants';

export const AddToCartIcon: React.FC<Props> = ({inCart}) => {
  return (
    <svg xmlns="http://www.w3.org/2000/svg" width={17} height={17} fill="none">
      <path
        stroke={inCart ? constants.colors.redColor : '#8A8D9F'}
        strokeLinecap="round"
        strokeLinejoin="round"
        d="M8.5 5.5v6m-3-3h6m4.5 0a7.5 7.5 0 1 1-15 0 7.5 7.5 0 0 1 15 0Z"
      />
    </svg>
  );
};
